/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.pishockapi;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import lombok.NonNull;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.OpType;
import moe.score.pishockzap.pishockapi.PiShockApi;
import moe.score.pishockzap.pishockapi.PiShockUtils;

public class PiShockWebApiV1
implements PiShockApi {
    @NonNull
    private static final URL API_URL;
    private final PishockZapConfig config;
    private final Logger logger = Logger.getLogger("PiShock-Zap");
    private final PiShockUtils.ShockDistributor distributor = new PiShockUtils.ShockDistributor();
    private final Executor executor;
    private final Gson gson = new Gson();

    public PiShockWebApiV1(PishockZapConfig config, Executor executor) {
        this.config = config;
        this.executor = executor;
    }

    @Override
    public void performOp(@NonNull ShockDistribution distribution, @NonNull OpType op, int intensity, float duration) {
        Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
        Objects.requireNonNull(op, "op is marked non-null but is null");
        if (!this.config.isEnabled()) {
            return;
        }
        if (this.config.isVibrationOnly()) {
            op = OpType.VIBRATE;
        }
        if (!PiShockUtils.shockParamsAreValid(intensity, duration)) {
            return;
        }
        if (this.config.getApiKey().isBlank()) {
            this.logger.warning("No PiShock API key configured");
            return;
        }
        if (this.config.getUsername().isBlank()) {
            this.logger.warning("No PiShock username configured");
            return;
        }
        String logIdentifier = this.config.getLogIdentifier();
        logIdentifier = logIdentifier.isBlank() ? "PiShock-Zap (Minecraft)" : logIdentifier.trim();
        String[] shockers = (String[])this.config.getShareCodes().stream().map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (shockers.length == 0) {
            this.logger.warning("No PiShock share codes configured");
            return;
        }
        boolean[] shocks = this.distributor.pickShockers(distribution, shockers.length);
        for (int i = 0; i < shocks.length; ++i) {
            if (!shocks[i]) continue;
            String shareCode = shockers[i];
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Username", this.config.getUsername());
            data.put("Code", shareCode);
            data.put("Name", logIdentifier);
            data.put("Apikey", this.config.getApiKey());
            data.put("Op", op.code);
            data.put("Intensity", intensity);
            data.put("Duration", this.transformDuration(duration));
            this.doApiCallOnThread(data);
        }
    }

    private int transformDuration(float duration) {
        float durationMs = duration * 1000.0f;
        if (durationMs <= 100.0f) {
            return 0;
        }
        return Math.round(durationMs);
    }

    private void doApiCallOnThread(Map<String, Object> data) {
        this.executor.execute(() -> {
            try {
                String response;
                URLConnection connection = API_URL.openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                try (OutputStream outputStream = connection.getOutputStream();){
                    String json = this.gson.toJson((Object)data);
                    outputStream.write(json.getBytes());
                }
                try (InputStream inputStream = connection.getInputStream();){
                    response = new String(inputStream.readAllBytes());
                }
                if (!response.contains("Operation Succeeded") && !response.contains("Operation Attempted")) {
                    this.logger.warning("PiShock API call failed; response: " + response);
                }
            }
            catch (Exception e) {
                this.logger.warning("PiShock API call failed; exception thrown");
                e.printStackTrace();
            }
        });
    }

    static {
        try {
            API_URL = URI.create("https://do.pishock.com/api/apioperate").toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

